/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import org.newdawn.slick.opengl.Texture;

public class Warthog
extends EntityLiving {
    public Warthog(World w) {
        super(w);
        this.maxrenderdist = 150;
        this.height = 0.98f;
        this.width = 0.98f;
        this.uniquename = "OreSpawn:Warthog";
        this.moveSpeed = 0.37f;
        this.setMaxHealth(35.0f);
        this.setHealth(35.0f);
        this.setDefense(3.0f);
        this.setAttackDamage(5.0f);
        this.searchDistance = 24.0f;
        this.attackRange = 1.5f;
        this.movefrequency = 45;
        this.setExperience(69);
        this.canSwim = true;
        this.daytimespawn = true;
        this.daytimedespawn = false;
        this.nighttimespawn = false;
        this.nighttimedespawn = true;
        this.temperament = 1;
        this.enable_hostile = true;
        this.tower_defense_enable = true;
    }

    public String getLivingSound() {
        int which = this.world.rand.nextInt(3);
        if (which == 2) {
            return "OreSpawn:Warthog_living3";
        }
        if (which == 1) {
            return "OreSpawn:Warthog_living2";
        }
        return "OreSpawn:Warthog_living1";
    }

    public String getHurtSound() {
        int which = this.world.rand.nextInt(3);
        if (which == 2) {
            return "OreSpawn:Warthog_hit3";
        }
        if (which == 1) {
            return "OreSpawn:Warthog_hit2";
        }
        return "OreSpawn:Warthog_hit1";
    }

    public String getDeathSound() {
        if (this.world.rand.nextBoolean()) {
            return "OreSpawn:Warthog_death2";
        }
        return "OreSpawn:Warthog_death1";
    }

    public void doDeathDrops() {
        int howmany = 3 + this.world.rand.nextInt(4);
        int i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosemeat.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        howmany = 1 + this.world.rand.nextInt(4);
        i = 0;
        while (i < howmany) {
            Utils.doDropRand((World)this.world, (int)0, (int)Items.moosebone.itemID, (float)2.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            ++i;
        }
        if (this.world.rand.nextBoolean()) {
            howmany = 1 + this.world.rand.nextInt(6);
            i = 0;
            while (i < howmany) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pig_guts.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                ++i;
            }
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pig_nose.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            howmany = 1 + this.world.rand.nextInt(4);
            i = 0;
            while (i < howmany) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pig_toes.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                ++i;
            }
        }
        if (this.world.rand.nextBoolean()) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pig_tail.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        if (this.world.rand.nextBoolean()) {
            howmany = 1 + this.world.rand.nextInt(2);
            i = 0;
            while (i < howmany) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.pig_ear.itemID, (float)3.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
                ++i;
            }
        }
        if (this.world.rand.nextInt(5) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophywarthog.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Warthog) {
            return false;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        return e instanceof Player && this.CanProbablySeeEntity(e);
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/WartHogtexture.png");
        }
        return this.texture;
    }
}

